--select * from V_BI_FILIAL
alter VIEW V_BI_FILIAL AS
SELECT
	PRC_FILIAL.CD_FILIAL AS Filial,
	NM_FILIAL_LISTA AS FilialNome,
	ISNULL(DATEDIFF ( MM , DT_INI_SISTEMA , GETDATE()),0) AS MesesVendaFilial,
	case when DATEDIFF ( MM , DT_INI_SISTEMA , GETDATE()) > 9 then
		'Nao'
	else
		'Sim'
	end as FilialNova,
	PRC_FILIAL.Cep,
	DS_CID as Cidade,
	GLB_CID.UF as UF,
	DS_UF AS Estado,
	Bairro,
	'Brasil' as Pais,
	ISNULL(NM_REGIAO_FILIAL,'NAO DEFINIDA') as RegiaoFilial,
	ISNULL(NM_USU,'NAO DEFINIDO') AS Supervisor,
	ISNULL(NM_GRP_ECON,'NAO DEFINIDO') AS GrupoEconomico,
	ISNULL(NM_BANDEIRA,'NAO DEFINIDO') AS Bandeira,
	PRC_FILIAL.FLAG_NAO_PARTIC_INDIC AS FlagNaoPartIndic,
	PRC_FILIAL.STS_FILIAL as StsFilial,
	PRC_FILIAL.TP_FILIAL  as TipoFilial
FROM
	PRC_FILIAL INNER JOIN GLB_CID ON
	PRC_FILIAL.CD_CID = GLB_CID.CD_CID
	INNER JOIN GLB_UF ON
	GLB_CID.UF = GLB_UF.UF 
	LEFT OUTER JOIN PRC_REGIAO_FILIAL_PRC_FILIAL ON
	PRC_FILIAL.CD_EMP = PRC_REGIAO_FILIAL_PRC_FILIAL.CD_EMP AND
	PRC_FILIAL.CD_FILIAL = PRC_REGIAO_FILIAL_PRC_FILIAL.CD_FILIAL 
	LEFT OUTER JOIN PRC_REGIAO_FILIAL ON
	PRC_REGIAO_FILIAL_PRC_FILIAL.CD_EMP = PRC_REGIAO_FILIAL.CD_EMP AND
	PRC_REGIAO_FILIAL_PRC_FILIAL.CD_REGIAO_FILIAL = PRC_REGIAO_FILIAL.CD_REGIAO_FILIAL
	LEFT OUTER JOIN GLB_USU ON
	PRC_REGIAO_FILIAL.CD_USU_SUPERVISOR = GLB_USU.CD_USU
	INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON
	PRC_FILIAL.CD_EMP = PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND
	PRC_FILIAL.CD_FILIAL = PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL 
	LEFT OUTER JOIN PRC_GRP_ECON ON
	PRC_GRP_ECON_PRC_FILIAL.CD_GRP_ECON = PRC_GRP_ECON.CD_GRP_ECON
	LEFT OUTER JOIN PRC_BANDEIRA_PRC_FILIAL ON
	PRC_FILIAL.CD_EMP = PRC_BANDEIRA_PRC_FILIAL.CD_EMP AND
	PRC_FILIAL.CD_FILIAL = PRC_BANDEIRA_PRC_FILIAL.CD_FILIAL
	LEFT OUTER JOIN PRC_BANDEIRA ON
	PRC_BANDEIRA_PRC_FILIAL.CD_BANDEIRA = PRC_BANDEIRA.CD_BANDEIRA